//-----------------------------------------------------------------------------
// Remote Boss Example for C#Builder
//
// FormServer.cs
//
// This is the server application for the "Remote Boss" Remoting example. It
// demonstrates:
// 1) Creating and register a remoting channel using TCP.
// 2) Using notifyIcon to hide the application in the notify area (system
//    tray).
//
// NOTE: This uses TCP port 3999. If that doesn't suit you then change it
//       in Main(). Make sure that you also change the RemotingClient project
//       to suit.
//
// By Jarrod Hollingworth
//-----------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
// Remoting
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Tcp;
using System.Runtime.Serialization;
// Start a process
using System.Diagnostics;
// Remote Boss.
using RemoteBoss;

namespace RemotingServer
{
  /// <summary>
  /// The server form.
  /// </summary>
  public class frmRemoteBossServer : System.Windows.Forms.Form
  {
    /// <summary>
    /// Required designer variable.
    /// </summary>
    private System.ComponentModel.IContainer components;
    private System.Windows.Forms.NotifyIcon notifyIconRunning;
    private System.Windows.Forms.Button btnHide;
    private System.Windows.Forms.ContextMenu contextMenu1;
    private System.Windows.Forms.MenuItem miExit;
    private System.Windows.Forms.Timer tmrMessageCheck;

    public frmRemoteBossServer()
    {
      //
      // Required for Windows Form Designer support
      //
      InitializeComponent();
    }

    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    protected override void Dispose (bool disposing)
    {
      if (disposing)
      {
        if (components != null)
        {
          components.Dispose();
        }
      }
      base.Dispose(disposing);
    }

    #region Windows Form Designer generated code
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    private void InitializeComponent() {
      this.components = new System.ComponentModel.Container();
      System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(frmRemoteBossServer));
      this.notifyIconRunning = new System.Windows.Forms.NotifyIcon(this.components);
      this.contextMenu1 = new System.Windows.Forms.ContextMenu();
      this.miExit = new System.Windows.Forms.MenuItem();
      this.btnHide = new System.Windows.Forms.Button();
      this.tmrMessageCheck = new System.Windows.Forms.Timer(this.components);
      this.SuspendLayout();
      // 
      // notifyIconRunning
      // 
      this.notifyIconRunning.ContextMenu = this.contextMenu1;
      this.notifyIconRunning.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIconRunning.Icon")));
      this.notifyIconRunning.Text = "Remote Boss Server";
      this.notifyIconRunning.Visible = true;
      this.notifyIconRunning.DoubleClick += new System.EventHandler(this.notifyIconRunning_DoubleClick);
      // 
      // contextMenu1
      // 
      this.contextMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
            this.miExit});
      // 
      // miExit
      // 
      this.miExit.Index = 0;
      this.miExit.Text = "E&xit";
      this.miExit.Click += new System.EventHandler(this.miExit_Click);
      // 
      // btnHide
      // 
      this.btnHide.Location = new System.Drawing.Point(60, 20);
      this.btnHide.Name = "btnHide";
      this.btnHide.TabIndex = 0;
      this.btnHide.Text = "&Hide";
      this.btnHide.Click += new System.EventHandler(this.btnHide_Click);
      // 
      // tmrMessageCheck
      // 
      this.tmrMessageCheck.Interval = 200;
      this.tmrMessageCheck.Tick += new System.EventHandler(this.tmrMessageCheck_Tick);
      // 
      // frmRemoteBossServer
      // 
      this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
      this.ClientSize = new System.Drawing.Size(194, 68);
      this.Controls.Add(this.btnHide);
      this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
      this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
      this.MaximizeBox = false;
      this.MinimizeBox = false;
      this.MinimumSize = new System.Drawing.Size(200, 100);
      this.Name = "frmRemoteBossServer";
      this.ShowInTaskbar = false;
      this.Text = "Remote Boss Server";
      this.Load += new System.EventHandler(this.frmRemoteBossServer_Load);
      this.ResumeLayout(false);
    }
    #endregion

    /// <summary>
    /// The main entry point for the application.
    /// </summary>
    [STAThread]
    static void Main()
    {
      try {
        // Create and register the remoting channel via TCP on port 3999.
        TcpServerChannel Channel = new TcpServerChannel(3999);
        ChannelServices.RegisterChannel(Channel);
        // Register the remote boss service. We use SingleCall to have one
        // instance per client.
        RemotingConfiguration.RegisterWellKnownServiceType(
            typeof(RemoteBossService),
            "RemoteBossService",
            WellKnownObjectMode.SingleCall);
      }
      catch (Exception) {
      }

      Application.Run(new frmRemoteBossServer());
    }

    private void btnHide_Click(object sender, System.EventArgs e)
    {
      // Hide the form.
      Visible = false;
    }

    private void notifyIconRunning_DoubleClick(object sender, System.EventArgs e)
    {
      // Show the form.
      Visible = true;
      Activate();
    }

    private void miExit_Click(object sender, System.EventArgs e)
    {
      Close();
    }

    private void frmRemoteBossServer_Load(object sender, System.EventArgs e)
    {
      tmrMessageCheck.Enabled = true;
    }
    
    private void tmrMessageCheck_Tick(object sender, System.EventArgs e)
    {
      // Check for new messages.
      string NewMessages = BossMessageList.GetInstance().GetMessages();
      if (NewMessages.Length > 0) {
        // Display the messages.
        frmMessage DisplayMessages = new frmMessage();
        DisplayMessages.txtMessage.Text = NewMessages;
        DisplayMessages.ShowDialog();
      }
    }
  }
}
